 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_DASHBOARD_VENDAS_FABRICANTES]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_DASHBOARD_VENDAS_FABRICANTES]
GO
--EXEC P_DASHBOARD_VENDAS_FABRICANTES 1,'','2017-12-01','2017-12-31',1
CREATE PROCEDURE P_DASHBOARD_VENDAS_FABRICANTES (@CD_EMP INT, 
											@CD_FILIAL VARCHAR(MAX)='',
											@DT_INI DATETIME, 
											@DT_FIM DATETIME, 
											@CD_USU INT=0)
AS
CREATE TABLE #_RS_FILIAL (CD_EMP INT, 
						  CD_FILIAL	INT)

    CREATE TABLE  #_EST_PROD (CD_EMP			INT,
							  CD_PROD			INT)
/****************************************************************************************************************
									P R O D U T O S
*****************************************************************************************************************/
 IF EXISTS(
			SELECT
				TOP 1
				CD_PROD
			FROM
				GLB_ARV_MERC_FILTROS
			WHERE
				CD_USU=@CD_USU
			) 
	BEGIN
		INSERT INTO #_EST_PROD
		SELECT 
			P.CD_EMP, 
			P.CD_PROD
		FROM
			EST_PROD P INNER JOIN GLB_ARV_MERC_FILTROS T ON
			P.CD_EMP = T.CD_EMP AND
			P.CD_PROD = T.CD_PROD 
		WHERE
			T.CD_USU = @CD_USU
	END
ELSE
	BEGIN
		INSERT INTO #_EST_PROD
		SELECT 
			P.CD_EMP, 
			P.CD_PROD
		FROM	  
		    EST_PROD P 
		WHERE
		   P.CD_EMP=@CD_EMP
	END

IF LTRIM(RTRIM(@CD_FILIAL))<>''
BEGIN
INSERT INTO #_RS_FILIAL 						
SELECT @CD_EMP, 
	ID 
FROM 
	UFD_PRM_IN_STRING(@CD_FILIAL)
END
ELSE
BEGIN
	INSERT INTO #_RS_FILIAL 						
	SELECT 
		CD_EMP,
		CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE
		CD_EMP = @CD_EMP
END

CREATE TABLE #RsVendas(CODIGO INT,
					   FABRICANTE VARCHAR(200),
					   VD_LIQUIDA MONEY,
					   VD_BRUTA MONEY,
					   CUSTOMEDIO MONEY,
					   VD_UNI INT,
					   MARGEM_BRUTA MONEY,
					   PERC_MARGEM MONEY,
					   PERC_CMV  MONEY)

CREATE TABLE #RsVendasGeral(VD_LIQUIDA		MONEY,
							CUSTOMEDIO		MONEY,
							VD_UNI			MONEY,
							MARGEM_BRUTA	MONEY)

INSERT INTO #RsVendas(CODIGO,
					   FABRICANTE,
					   VD_LIQUIDA,
					   VD_BRUTA,
					   CUSTOMEDIO,
					   VD_UNI,
					   MARGEM_BRUTA,
					   PERC_MARGEM,
					   PERC_CMV)
SELECT 
	V_BI_EST_PROD.CdFABRICANTE,
	V_BI_EST_PROD.NOMEFABRICANTE AS FABRICANTE,
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),2), 
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD),2), 
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2), 
	SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_ITENS),
	ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ-EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2),
	CASE WHEN ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),0) > 0 THEN
		(ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ-EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2) / ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),2))*100
	ELSE
		0
	END,
	CASE WHEN ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),0) > 0 THEN
		100 - (ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ-EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD),2) / ROUND(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ),2))*100
	ELSE
		0
	END
FROM            
	EST_MOVIMENTO_VENDAS_PRODUTOS INNER JOIN EST_MOVIMENTO_VENDAS ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
	INNER JOIN GLB_DT_MOVIMENTO ON
	EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
	INNER JOIN #_RS_FILIAL f ON
	EST_MOVIMENTO_VENDAS.CD_FILIAL = f.CD_FILIAL
	INNER JOIN V_BI_EST_PROD ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PROD = V_BI_EST_PROD.produto
	INNER JOIN #_EST_PROD p ON
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_EMP = p.CD_EMP AND
	EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PROD = p.CD_PROD 
WHERE
	EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0,2,3,10,11)
	AND GLB_DT_MOVIMENTO.DT_MOVIMENTO BETWEEN @DT_INI AND @DT_FIM
GROUP BY
	V_BI_EST_PROD.CdFABRICANTE,
	V_BI_EST_PROD.NOMEFABRICANTE

INSERT INTO #RsVendasGeral (VD_LIQUIDA,
							CUSTOMEDIO,
							VD_UNI,
							MARGEM_BRUTA)
SELECT
	SUM(VD_LIQUIDA),
	SUM(CUSTOMEDIO),
	SUM(VD_UNI),
	SUM(MARGEM_BRUTA)
FROM
	#RsVendas

SELECT 
	v.CODIGO,
	v.FABRICANTE,
	v.VD_BRUTA,
	(v.VD_BRUTA-v.VD_LIQUIDA) AS VLR_DESCONTO,
	v.VD_LIQUIDA,
	CASE WHEN ISNULL(vg.VD_LIQUIDA,0) > 0 THEN
		(v.VD_LIQUIDA/vg.VD_LIQUIDA) * 100 
	ELSE
		0
	END AS PART_VD_LIQUIDA,
	CASE WHEN ISNULL(v.VD_BRUTA,0) > 0 THEN
		((v.VD_BRUTA-v.VD_LIQUIDA) / v.VD_BRUTA)*100 
	ELSE
		0
	END AS PERC_DESC,
	v.CUSTOMEDIO,
	V.MARGEM_BRUTA,
	CASE WHEN ISNULL(vg.MARGEM_BRUTA,0) > 0 THEN
		(v.MARGEM_BRUTA/vg.MARGEM_BRUTA) * 100 
	ELSE
		0
	END AS PART_MARGEM,
	V.PERC_MARGEM,
	V.PERC_CMV,
	v.VD_UNI,
	CASE WHEN ISNULL(vg.VD_UNI,0) > 0 THEN
		(v.VD_UNI/vg.VD_UNI) * 100 
	ELSE
		0
	END AS PART_VD_UNI
FROM 
	#RsVendas v,
	#RsVendasGeral vg
ORDER BY
	V.FABRICANTE
DROP TABLE #RsVendas;
DROP TABLE #RsVendasGeral;